#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-10193: VAR & Utility Integration - Direct Scheduling - New Appointment Form - Filter Clinics by selected location]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @modal = Modal.new(@driver)
    TITLE = "Appointments/Requests"
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-10482|TC#VAR-10483: VAR & Utility Integration - Direct Scheduling - New Appointment Form - Filter Clinics by selected location' do

    it 'should display clinics list for a given type of care at my selected location' do
      #Select Type of Care = Primary Care, Location = Boston, and Scheduling Method = Direct
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")


      #Clinics should populate. Verify only Parent Clinics Populate
      @new_appointment.mutiple_clinics_element.wait_until_present(TIME_OUT_LIMIT)
      expected_content =[\
                        "BO PACT B1",
                        "JP PRIMARY CARE DR. CREAMER",
                        "BO PCC QUICK ACCESS AM 2204",
                        "Primary Care - No Time Slot"
      ]

      actual_content = @new_appointment.mutiple_clinics_element.text.split("\n")

      compareContents(actual_content,  expected_content)
    end

    it "Should verify clinic list change when new location is selected" do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("636A8")
      @new_appointment.selectSchedulingMethod("direct")
      @new_appointment.single_clinic_info_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.single_clinic_info_element.text).to eq("Sanctum Sanctorum")
    end

  end

end